package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Visible extends Modifier {
	private static String xmlID = "VISIBLE";

	public Visible(Element root) {
		super(root, Visible.xmlID);
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (o.getTypes().contains("MENTAL")
				&& (GenericObject.findObjectByID(o.getAssignedModifiers(),
						"BASEDONCON") == null)
				&& (GenericObject.findObjectByID(o.getAssignedModifiers(),
						"BOECV") == null)) {
			return "";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(), "INVISIBLE") != null) {
			return getDisplay()
					+ " cannot be applied to a Power/ability with the Invisible Advantage on it.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(), "FOCUS") != null) {
			Focus focus = (Focus) GenericObject.findObjectByID(o
					.getAssignedModifiers(), "FOCUS");
			if ((focus.getSelectedOption() != null)
					&& focus.getSelectedOption().getXMLID().startsWith("O")) {
				return getDisplay()
						+ " cannot be taken with the Limitation Focus if the Focus is Obvious.";
			}
		}
		if ((o.getParentList() != null)
				&& (GenericObject.findObjectByID(o.getParentList()
						.getAssignedModifiers(), "FOCUS") != null)) {
			Focus focus = (Focus) GenericObject.findObjectByID(o
					.getParentList().getAssignedModifiers(), "FOCUS");
			if (!focus.isPrivate() && (focus.getSelectedOption() != null)
					&& focus.getSelectedOption().getXMLID().startsWith("O")) {
				return getDisplay()
						+ " cannot be taken with the Limitation Focus if the Focus is Obvious.";
			}
		}
		return "";
	}
}